/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.pizzacraft.compat.jei;

import com.tiviacz.pizzacraft.compat.jei.ChoppingRecipeCategory;
import com.tiviacz.pizzacraft.compat.jei.CrushingRecipeCategory;
import com.tiviacz.pizzacraft.compat.jei.MortarRecipeCategory;
import com.tiviacz.pizzacraft.init.ModBlocks;
import com.tiviacz.pizzacraft.init.ModRecipes;
import com.tiviacz.pizzacraft.recipes.chopping.ChoppingRecipe;
import com.tiviacz.pizzacraft.recipes.crushing.CrushingRecipe;
import com.tiviacz.pizzacraft.recipes.mortar.MortarRecipe;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.common.plugins.vanilla.crafting.CategoryRecipeValidator;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class PizzaCraftPlugin
implements IModPlugin {
    @Nullable
    private IRecipeCategory<ChoppingRecipe> choppingCategory;
    @Nullable
    private IRecipeCategory<MortarRecipe> mortarCategory;
    @Nullable
    private IRecipeCategory<CrushingRecipe> crushingCategory;

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[1];
        this.choppingCategory = new ChoppingRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        iRecipeCategoryArray[0] = this.choppingCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
        IRecipeCategory[] iRecipeCategoryArray2 = new IRecipeCategory[1];
        this.mortarCategory = new MortarRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        iRecipeCategoryArray2[0] = this.mortarCategory;
        registration.addRecipeCategories(iRecipeCategoryArray2);
        IRecipeCategory[] iRecipeCategoryArray3 = new IRecipeCategory[1];
        this.crushingCategory = new CrushingRecipeCategory(registration.getJeiHelpers().getGuiHelper());
        iRecipeCategoryArray3[0] = this.crushingCategory;
        registration.addRecipeCategories(iRecipeCategoryArray3);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (Block choppingBoard : ModBlocks.getChoppingBoards()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)choppingBoard), new RecipeType[]{ChoppingRecipeCategory.CHOPPING});
        }
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MORTAR_AND_PESTLE.get()), new RecipeType[]{MortarRecipeCategory.MORTAR});
        for (Block basin : ModBlocks.getBasins()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)basin), new RecipeType[]{CrushingRecipeCategory.CRUSHING});
        }
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("pizzacraft", "pizzacraft");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(ChoppingRecipeCategory.CHOPPING, this.getChoppingRecipes(this.choppingCategory));
        registration.addRecipes(MortarRecipeCategory.MORTAR, this.getMortar(this.mortarCategory));
        registration.addRecipes(CrushingRecipeCategory.CRUSHING, this.getCrushing(this.crushingCategory));
    }

    public List<ChoppingRecipe> getChoppingRecipes(IRecipeCategory<ChoppingRecipe> chopping) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(chopping, 1);
        return PizzaCraftPlugin.getValidHandledRecipes(Minecraft.m_91087_().f_91073_.m_7465_(), (net.minecraft.world.item.crafting.RecipeType)ModRecipes.CHOPPING_RECIPE_TYPE.get(), validator);
    }

    public List<MortarRecipe> getMortar(IRecipeCategory<MortarRecipe> mortar) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(mortar, 4);
        return PizzaCraftPlugin.getValidHandledRecipes(Minecraft.m_91087_().f_91073_.m_7465_(), (net.minecraft.world.item.crafting.RecipeType)ModRecipes.MORTAR_RECIPE_TYPE.get(), validator);
    }

    public List<CrushingRecipe> getCrushing(IRecipeCategory<CrushingRecipe> crushing) {
        CategoryRecipeValidator validator = new CategoryRecipeValidator(crushing, 1);
        return PizzaCraftPlugin.getValidHandledRecipes(Minecraft.m_91087_().f_91073_.m_7465_(), (net.minecraft.world.item.crafting.RecipeType)ModRecipes.CRUSHING_RECIPE_TYPE.get(), validator);
    }

    private static <C extends Container, T extends Recipe<C>> List<T> getValidHandledRecipes(RecipeManager recipeManager, net.minecraft.world.item.crafting.RecipeType<T> recipeType, CategoryRecipeValidator<T> validator) {
        return recipeManager.m_44013_(recipeType).stream().filter(arg_0 -> validator.isRecipeHandled(arg_0)).toList();
    }
}

